<?LassoScript

	// Initialization
	//
	// This page initializes the example.  It authenticates the user and sets up
	// the required databases, tables, and groups.

	// Authentication
	//
	// Only members of the 'administrators' group or the 'OP Poll Admins' group can
	// access this interface.

	auth_group: (array: 'administrators', 'OP Poll Admins');

	// For debugging the log level can be modified to sql
	var: 'log_level' = 'critical';
	
	// Database and Group
	//
	// The [ExamplesPack_Initialize] tag is used to create the database, tables,
	// and group required by the Poll example.  The following structure is created.
	//
	// op_quick_poll
	//
	//  prefs
	//    id
	//    prefs - global preferences stores serialized map
	//
	//  polls
	//    id
	//    code - user defined code which identifies the poll
	//    title - display title
	//    status - true = visible, false = hidden
	//    archive - true = locked, false = active
	//    current - true = current, false = regular
	//    question - display question
	//    results - display results footer
	//    display - display footer
	//    frequency - how often each user can vote (once,hour,day,month)
	//    prefs - poll preferences stores serialized map
	//
	//  answers - two or more answers per poll
	//    id
	//    poll_id - relation
	//    answer - display answer
	//    result - current results count for this answer
	//    sort - numeric order for answers
	//
	//  results
	//    id
	//    poll_id - relation
	//    answer_id - relation
	//    datetime - when the vote was cast
	//    ipaddress - ip of the user who cast the vote
	//
	
	if: ((Application_WasInitialized: -AppName=Application_AppInfo->Title, -Version=Application_AppInfo->Version) == false);
		var: 'initializeResults'=(Application_Initialize: 
			-AppName=Application_AppInfo->Title,
			-Version=Application_AppInfo->Version,
			-Config=(Array: 
				-Group=(Pair: 'OP Poll Admins'='Users which are allowed to administer the quick poll system.'),
				-Database=(Pair: 'op_quick_poll'=(Array:
					-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X'),
					-Table=(Pair: 'prefs'=(Array: 
						-SQL='CREATE TABLE prefs ( \
							id INTEGER PRIMARY KEY, \
							prefs TEXT)',
						-group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
					-Table=(Pair: 'polls'=(Array: 
						-SQL='CREATE TABLE polls ( \
							id INTEGER PRIMARY KEY, \
							code TEXT, \
							title TEXT, \
							status TEXT DEFAULT "true", \
							archive TEXT DEFAULT "false", \
							current TEXT DEFAULT "false", \
							question TEXT, \
							results TEXT,
							display TEXT,
							frequency TEXT DFEAULT "day",
							prefs TEXT DEFAULT "<mapType></mapType>");',
						-SQL='CREATE INDEX code ON polls (code)',
						-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
					-Table=(Pair: 'answers'=(Array: 
						-SQL='CREATE TABLE answers ( \
							id INTEGER PRIMARY KEY, \
							poll_id INTEGER, \
							answer TEXT, \
							result INTEGER DEFAULT "0", \
							sort INTEGER DEFAULT "1");',
						-SQL='CREATE INDEX poll_id ON answers (poll_id)',
						-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
					-Table=(Pair: 'results'=(Array: 
						-SQL='CREATE TABLE results ( \
							id INTEGER PRIMARY KEY, \
							poll_id INTEGER, \
							answer_id INTEGER, \
							datetime TEXT, \
							ipaddress TEXT);',
						-SQL='CREATE INDEX poll_id ON results (poll_id)',
						-SQL='CREATE INDEX answer_id ON results (answer_id)',
						-SQL='CREATE INDEX datetime ON results (datetime)',
						-SQL='CREATE INDEX ipaddress ON results (ipaddress)',
						-Group=(Pair: 'ANYUSER'='I,S,A,U,D,X')
					)),
				))
			)
		);

		// if the application was just now initialized, add a starter poll with answers and results
		if ($initializeResults->size);
			inline: -log=$log_level,
					-findall,
					-database='op_quick_poll',
					-table='prefs';
				var: 'today' = date->(format: '%Q %T');
				if: (found_count == 0);
					inline: -log=$log_level,
							-SQL='\
							INSERT INTO prefs VALUES (1,"<mapType></mapType>"); \
							INSERT INTO polls VALUES (1,"EXAMPLE","Favorite Color","true","false","true","What is your favorite color?","","","day","<mapType><mapElement key=""answers_3_color""><stringType>yellow</stringType></mapElement><mapElement key=""answers_2_color""><stringType>orange</stringType></mapElement><mapElement key=""answers_1_color""><stringType>red</stringType></mapElement><mapElement key=""display_background""><stringType>black</stringType></mapElement><mapElement key=""display_title_background""><stringType>red</stringType></mapElement><mapElement key=""display_title_color""><stringType>black</stringType></mapElement><mapElement key=""display_color""><stringType>red</stringType></mapElement><mapElement key=""answers_6_color""><stringType>purple</stringType></mapElement><mapElement key=""answers_5_color""><stringType>blue</stringType></mapElement><mapElement key=""answers_4_color""><stringType>green</stringType></mapElement></mapType>"); \
							INSERT INTO answers VALUES (1,1,"Red",3,1); \
							INSERT INTO answers VALUES (2,1,"Orange",2,2); \
							INSERT INTO answers VALUES (3,1,"Yellow",1,3); \
							INSERT INTO answers VALUES (4,1,"Green",3,4); \
							INSERT INTO answers VALUES (5,1,"Blue",1,5); \
							INSERT INTO answers VALUES (6,1,"Purple",2,6); \
							INSERT INTO results VALUES (1,1,1,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,1,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,1,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,2,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,2,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,3,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,4,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,4,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,4,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,5,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,6,"' + $today + '","0.0.0.0"); \
							INSERT INTO results VALUES (1,1,6,"' + $today + '","0.0.0.0"); \
						';
					/inline;
				/if;
			/inline;
		/if;
	/if;
	
?>
